/* gtk_domain.c
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include <polylib/polylib32.h>

#include "domains.h"
#include "gtk_domain.h"
#include "gtk_repere.h"
#include "gtk_ddraw.h"
#include "gtk_windows.h"
 
Polyhedron *A_Conv, *A_Union;
static Polyhedron *Contexte, *PParam;
int DimNP=0;
int NbParam=0;
int *ValidParam;
int *ValeurParam;
int is_pt_selected=0;

float MaxX, MaxY, MinX, MinY;
int Width, Height;
 
static Point cxy;
static float dist;
int pt_selected[MAXDIM];
int intpoints = 1;

void active_intpoints(GtkWidget *widget, gpointer data) 
{
	if( A_Conv )
	{
		intpoints = !intpoints;
		gtk_label_set((GtkLabel *)pt_selected_panel, "");
		domain_redraw(dg);
	}
}

/************************************************************************/
/* domain_redraw() : draw domain in the pixmap p		            */
/************************************************************************/
void domain_redraw(GdkDrawable *pixmap) {
GdkRectangle update_rect;

	/*--- clear domain window ----*/
	if (whitePen) { /*-- whitePen may have not been created yet --*/
		gdk_draw_rectangle (pixmap,whitePen,TRUE,0, 0,
                      domain_canvas->allocation.width,
                      domain_canvas->allocation.height);
	}

	if( A_Union && A_Conv->NbRays != 0 )
	{
		/* calcul des extremas pour le centrage de la figure */
		Calc_Extr();

		/********************************/
		/* Redisplay the domain	        */
		/********************************/

		/* affiche le polyedre ITself */
		Draw_Domain( pixmap, A_Union, dgGC, 0 );

		/* affiche les points entiers dans le polyedre */
		if( intpoints )
			if( Draw_Int_Points( pixmap , A_Union, dgGC ) )
			{
				/* affiche en couleur le point selectionne */
				if( is_pt_selected )
				{
					int i;
					char s[100];
					AffPoint( pixmap , pt_selected, bluePen );
					sprintf(s,"\n(%d", pt_selected[0]);
					for( i=1 ; i<DimNP ; ++i )
						sprintf( s, "%s,%d", s, pt_selected[i] );
					strcat( s, ")" );
					gtk_label_set((GtkLabel *)pt_selected_panel, s); 
				}
			}

	}
	/* call an expose event */
	update_rect.x=0;
	update_rect.y=0;
	update_rect.width=domain_canvas->allocation.width ;
	update_rect.height=domain_canvas->allocation.height;
	gtk_widget_draw(domain_canvas,&update_rect);
}

/************************************************************************/
/* DomVisual()                                                          */
/************************************************************************/
void DomVisual( Polyhedron *Pol, Polyhedron *Cont, char **pname, char *wname )
{
	Polyhedron *d, *Conv;

	if( !Pol )
		return;

/*	if( Pol->next )
	{
		Conv = DomainConvex( Pol, WS );
		d = DomainDifference( Conv, Pol, WS );
		if( emptyQ(d) )
			PParam = Conv;
		else
		{
			PParam = Pol;
			Polyhedron_Free( Conv );
		}
	}
	else */
		PParam = Pol;

	Contexte = Cont;

/*************** Polyhedron *A = polyedre parametre *************/
/*************** Polyhedron *Contexte = contexte  *************/
	if( Contexte )
		NbParam = Contexte->Dimension ;
	else
		NbParam = 0;

	if( NbParam==0 ) 
	{
		/* il n'y a pas de parametres */
		A_Union = PParam;
		A_Conv = DomainConvex( PParam, WS );
		DimNP = PParam->Dimension;
		Calc_Extr();
		calc_rep_extr();
	}
	else
	{
		if( NbParam >= PParam->Dimension )
		{
			/**** more parameters than variables ! *****/
			fprintf(stderr,"Domain d1 is smaller than context d2 !" );
			return;
		}
		ValidParam = (int *)malloc( NbParam*sizeof(int) );
		memset( ValidParam, 0, NbParam*sizeof(int) );
		ValeurParam = (int *)malloc( NbParam*sizeof(int) );

		DimNP = PParam->Dimension - NbParam;
		A_Conv = NULL;
		A_Union = NULL;
	}


	/* init_Colors(); has been moved after initDomainFrame cause dg must exist before calling it */
 
	intpoints = 1;
	initDomainFrame(pname, wname, NbParam);
	init_Colors();

	/* initializes the projection */
	rep_init();

	gtk_main();
	
}
/************************************************************************/
/* Warn()								*/
/************************************************************************/
void Warn( char *s )
{
	g_print("%s\n",s);
}
/************************************************************************/
/* Polyhedron()								*/
/************************************************************************/
/* calcul du polyhedre non parametre correspondant a l'instantiation
			des params dans p. */
static Polyhedron *NP_Domain( Polyhedron *P )
{
	Matrix *CNP;	 /* Non-Parameterized constraints */
	Polyhedron *DNP;
	int l,k;

	if( !P )
		return( NULL );

	CNP = Matrix_Alloc( P->NbConstraints, DimNP+2 );
	for( l=0 ; l<P->NbConstraints ; ++l )
	{
		/* les dnp+1 premieres colonnes */
		for( k=0 ; k<=DimNP ; ++k )
			CNP->p[l][k] = P->Constraint[l][k];

		/* la constante : */
		CNP->p[l][DimNP+1] = P->Constraint[l][1+P->Dimension];
		for( k=0 ; k<NbParam ; ++k )
			CNP->p[l][DimNP+1] += ValeurParam[k] * P->Constraint[l][DimNP+1+k];
	}
	DNP = Constraints2Polyhedron( CNP, WS );
	Matrix_Free( CNP );

	if( DNP == NULL )
		fprintf( stderr,"Internal error, DNP=NULL\n");

	DNP->next = NP_Domain( P->next );
	return DNP;
}

int isanumber( char *s )
{
	if( *s=='+' || *s=='-' )
		++s;
	if( ! *s )
		return( 0 );
	if( strcspn(s,"1234567890") != 0 )
		return( 0 );
	else
		return( 1 );

}

/************************************************************************/
/* chg_param () : one of the entries has changed			*/
/************************************************************************/
void chg_param(GtkWidget *widget, GtkWidget *entry)
{
	int n,i,j;
	Matrix *r;
	Polyhedron *p;

	/*--- look for the parameter that has changed ---*/
	for( n=0 ; n<NbParam ; ++n )
	{
			/* si c'est pas celui la on continue. */
			if( B_Tab[n] == widget )
					break;
	}
	if( n==NbParam )
	{
		fprintf( stderr,
		"Internal error: Can't find parameter panel_item.\n" );
		return;
	}
	is_pt_selected = 0;
	if( isanumber((char *)gtk_entry_get_text(GTK_ENTRY(entry))) )
	{
		ValidParam[n] = 1;
		ValeurParam[n] = atoi( (char *)gtk_entry_get_text(GTK_ENTRY(entry)) );
		for( i=0 ; i<NbParam ; ++i )
			if( !ValidParam[i] )
				break;
		if( i==NbParam )
		{
			/************ LES PARAMS SONT OK ************/
			/* verifier bon contexte */
			if( ! DansPolyedre( Contexte, ValeurParam ) )
			{
				if( A_Union )
					Domain_Free( A_Union );
				if( A_Conv )
					Domain_Free( A_Conv );
				A_Union = NULL;
				A_Conv = NULL;
				domain_redraw( dg ); 
			}
			else
			{
				/*-- recompute A ---*/
				if( A_Union )
					Domain_Free( A_Union );
				if( A_Conv )
					Domain_Free( A_Conv );
				A_Union = NP_Domain( PParam );
				r = Matrix_Alloc( WS, DimNP+2 );
				r->NbRows = 0;
				for( p=A_Union ; p ; p=p->next )
					for( j=0 ; j<p->NbRays ; j++ )
						memcpy( r->p[r->NbRows++], p->Ray[j], (DimNP+2)*sizeof(int) );
				A_Conv = Rays2Polyhedron( r, WS );
				Matrix_Free( r );
				calc_rep_extr();
				/*---- redraw domain ---*/
				domain_redraw( dg ); 
			}
		}
	}
	else
	{
		ValidParam[n] = 0;
		A_Union = NULL;
		A_Conv = NULL;
		domain_redraw( dg ); 
	}
}
/************************************************************************/
/* CalcFaces() d'un polyedre (pas d'une union)                          */
/************************************************************************/
Faces *CalcFaces( Polyhedron *P )
{
	int i;
	Faces *f, *tmp;
	Matrix *contraintes;

	if( P->Dimension < 2 )
		return( NULL );
 
	/* allocation dynamique des faces (Faces *) du polyedre */
	f = NULL;
	contraintes = Polyhedron2Constraints( P );
	for( i=0 ; i<P->NbConstraints ; ++i )
	{
		/* intersection entre ce plan et le polyedre entier */
		if( contraintes->p[i][0] != 0 )
		{
			tmp = f;
			f = (Faces *)malloc( sizeof(Faces) );
			f->next = tmp;
	 		/*--- makes an equality from inequality---*/
			contraintes->p[i][0] = 0; 
			f->P = Constraints2Polyhedron( contraintes, WS );

			/* contraintes est modifie par C2P !!! */
			memcpy( &contraintes->p[0][0], &P->Constraint[0][0],
						sizeof(int)*(P->Dimension+2)*P->NbConstraints );
		}
	}
	Matrix_Free( contraintes );

	return( f );
}

void FreeFaces( Faces *F )
{
	Faces *fs;
	while( F )
	{
		fs = F->next;
		Polyhedron_Free(F->P);
		free(F);
		F = fs;
	}
}		  

/****************************************************/
/* Routines pour la selection d'un point du domaine */
/****************************************************/
static int _find_near_pt( int *pt )
{
	Point xypt;
	float d;

	xypt = ProjectionPointEntier( pt, DimNP );
	d = sqrt( (xypt.x-cxy.x)*(xypt.x-cxy.x) +
		(xypt.y-cxy.y)*(xypt.y-cxy.y) );
	if( dist<0. || d<dist )
	{
		dist = d;
		/*--- a closest one has been found -----*/
		memcpy( pt_selected, pt, DimNP*sizeof(int) );
	}
	return 1;
}

static int sel=0;
/************************************************************************/
/* domain_event() : called after an event_button_pressed in the domain	*/
/* window. Computes which point must be highligthed.			*/
/************************************************************************/
void domain_event(int cx,int cy)
{
	Polyhedron *pp;
	int pt[MAXDIM];

	if( !intpoints )
		return;
	sel =!sel;
	 /* cherche le point le plus proche du clic souris */
	 
	cxy.x = (float)((cx - DOMAIN_BORD/2)*(MaxX-MinX))/DWIDTH + MinX;
	cxy.y = (float)((-cy + Height - DOMAIN_BORD/2)*(MaxY-MinY))
						/DHEIGHT + MinY;
	dist = -1.;
	for( pp=A_Union ; pp ; pp=pp->next )
		FORALL_P_do( pp, pt, _find_near_pt );
			if( dist != -1. ) {
				is_pt_selected = 1;
				domain_redraw( dg );
			}

 }
