/* gtk_windows.c
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/
/************************************************************************/
/*routines for :														*/
/*	- creation of the gtk windows  										*/
/* 	- gtk event handling code for actions in windows					*/
/************************************************************************/
#include <gtk/gtk.h>
#include <math.h>
#include <stdlib.h>

#include "domains.h"
#include "visutypes.h"
#include "gtk_domain.h"
#include "gtk_windows.h"
#include "gtk_repere.h"
#include "gtk_ddraw.h"
#include "gtk_context.h"
#include "gtk_properties.h"
#include "icon.xpm"

/*--- global variables ----*/
GtkWidget *domain_frame;
GtkWidget *rep_frame;
GtkWidget *domain_canvas;
GtkWidget *rep_canvas;
GtkWidget *pt_selected_panel;
GtkWidget **B_Tab, **L_Tab;	/* labels and text entries for parameters */
GtkWidget *view_button;
GtkWidget *properties_button, *context_button;
int prevx, prevy;
GdkDrawable *rg = NULL;	/*--- pixmap for domain drawing ---*/
GdkDrawable *dg = NULL;	/*--- pixmap for projection drawing ---*/
GdkGC *rgGC;
GdkGC *dgGC;
GdkPixmap *rep_iconpixmap;
GdkBitmap *rep_iconmask;

/********************* CALLBACKS FOR DOMAIN *****************************/

gboolean quit_Callback (GtkWidget * widget)
{
  gboolean test;
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (widget)))
    gtk_widget_hide (GTK_WIDGET (widget));
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (DlgWindow)))
    test = ExitDomainsProperties (GTK_WIDGET (DlgWindow));
  if ((GTK_IS_WIDGET (ContextWin)) && 
      (GTK_WIDGET_VISIBLE (GTK_WIDGET (ContextWin))))
    {
      test = context_window_exit (GTK_WIDGET (ContextWin));
      gtk_widget_destroy (GTK_WIDGET (ContextWin));
      ContextWin = NULL;
    }
  if ((GTK_IS_WIDGET (rep_frame)) && 
      GTK_WIDGET_VISIBLE (GTK_WIDGET (rep_frame)))
    {
      test = repere_exit (GTK_WIDGET (rep_frame));
      gtk_widget_destroy (GTK_WIDGET (rep_frame));
      rep_frame = NULL;
    }
  gtk_main_quit();
//  return TRUE;
}


/************************************************************************/
/* Create a new backing pixmap of the appropriate size 					*/
/* configure_event is issued for window creation and resizing			*/
/************************************************************************/
static gint
domain_configure_event (GtkWidget * widget, GdkEventConfigure * event)
{
  GdkColor *c;

  if (dg)
    gdk_pixmap_unref (dg);

   /*--create a new pixmap ------------*/
  dg = gdk_pixmap_new (widget->window,
		       widget->allocation.width,
		       widget->allocation.height, -1);

  c = (GdkColor *) g_malloc (sizeof (GdkColor));
  c->red = 0;
  c->green = 0;
  c->blue = 0;
  gdk_color_alloc (gdk_colormap_get_system (), c);

  dgGC = gdk_gc_new (widget->window);
  gdk_gc_set_foreground (dgGC, c);

  Width = widget->allocation.width;
  Height = widget->allocation.height;

   /*--creates a new pixmap --------------*/
  gdk_draw_rectangle (dg,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      widget->allocation.width, widget->allocation.height);

  domain_redraw (dg, NULL);	/* draw domain in the backing domain_pixmap */
  return TRUE;
}

/************************************************************************/
/* domain_expose_event()												*/
/* redraw the content of the window from the backing domain_pixmap		*/
/************************************************************************/
static gint domain_expose_event (GtkWidget * widget, GdkEventExpose * event)
{
  /* draw the contents of the domain pixmap */
  gdk_draw_pixmap (widget->window,
		   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		   dg,
		   event->area.x, event->area.y,
		   event->area.x, event->area.y,
		   event->area.width, event->area.height);
  return (FALSE);
}

/************************************************************************/
/* domain_button_press_event()						*/
/************************************************************************/
static void
domain_button_press_event (GtkWidget * widget, GdkEventButton * event)
{
  domain_event (event->x, event->y);
}

/****************** CALLBACKS FOR PROJECTION WINDOW *********************/

/************************************************************************/
/* repere_exit()	            					*/
/* Sortie de la Fentre du repre                 			*/
/************************************************************************/
gboolean repere_exit (GtkWidget * widget)
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (view_button), FALSE);
  return TRUE;
}

/************************************************************************/
/* repere_configure_event()						*/
/* Create a new backing pixmap of the appropriate size 			*/
/************************************************************************/
gint repere_configure_event (GtkWidget * widget, GdkEventConfigure * event)
{
  GdkColor *c;

  if (rg)
    gdk_pixmap_unref (rg);

  /*--create a new pixmap ------------*/
  rg = gdk_pixmap_new (widget->window,
		       widget->allocation.width,
		       widget->allocation.height, -1);
  c = (GdkColor *) g_malloc (sizeof (GdkColor));
  c->red = 0;
  c->green = 0;
  c->blue = 0;
  gdk_color_alloc (gdk_colormap_get_system (), c);

  rgGC = gdk_gc_new (widget->window);
  gdk_gc_set_foreground (rgGC, c);

  /*--create a new pixmap ------------*/
  gdk_draw_rectangle (rg,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      widget->allocation.width, widget->allocation.height);

  repere_redraw (rg);

  return TRUE;
}

/************************************************************************/
/* repere_motion_notify_event()	: mouse movement                    */
/************************************************************************/
gboolean
repere_motion_notify_event (GtkWidget * widget, GdkEventMotion * event,
			    gpointer user_data)
{
  static int selected;
  int i;
  float dist = 0;
  GdkModifierType state;
  int x, y;

  if (event->is_hint)
    {
      /* --- Get new position --- */
      gdk_window_get_pointer (event->window, &x, &y, &state);
    }
  else
    {
      /* --- Get new position --- */
      x = event->x;
      y = event->y;
      state = event->state;
    }
  /* --- If the mouse button is down --- */
  if (state & GDK_BUTTON1_MASK && rg != NULL)
    {
	/*--- choix de l'axe selectionnee -----*/
      selected = -1;
      for (i = 0; i < DimNP; ++i)
	{
	  float xt, yt, disttmp;

	  xt = ((float) (x - BORD) / repere.width) *
	    (repere.maxx - repere.minx) + repere.minx - repere.matrice[i][0];
	  yt = ((float) (repere.height + BORD - y) / repere.height) *
	    (repere.maxy - repere.miny) + repere.miny - repere.matrice[i][1];

	  disttmp = xt * xt + yt * yt;
	  if (disttmp < dist || selected == -1)
	    {
	      dist = disttmp;
	      selected = i;
	    }
	}
      repere.matrice[selected][0] =
	((float) (x - BORD) / repere.width) *
	(repere.maxx - repere.minx) + repere.minx;
      repere.matrice[selected][1] =
	((float) (repere.height + BORD - y) / repere.height) *
	(repere.maxy - repere.miny) + repere.miny;
      repere_redraw (rg);
      domain_redraw (dg, NULL);
    }
  else
    {
		/*--- button is released : recompute position -----*/
      calc_rep_extr ();
      repere_redraw (rg);
    }
  return (FALSE);/*-- means other events are also considered --*/
}

/************************************************************************/
/* repere_expose_event() : Redraw the screen from the backing pixmap 	*/
/* when Window is created and resized 									*/
/************************************************************************/
gint repere_expose_event (GtkWidget * widget, GdkEventExpose * event)
{

  gdk_draw_pixmap (widget->window,
		   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		   rg,
		   event->area.x, event->area.y,
		   event->area.x, event->area.y,
		   event->area.width, event->area.height);
  return (FALSE);
}

/******************** WINDOW CREATION ***********************************/

/************************************************************************/
/* create_domain_frame () :   											*/
/************************************************************************/
GtkWidget *create_domain_frame ()
{
  GtkWidget *hbox2;
  GtkWidget *vbox1;
  GtkWidget *quit_button;
  GdkPixmap *iconpixmap;
  GdkBitmap *iconmask;


  domain_frame = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (domain_frame), "VisuDomain",
			  "VisuDomain");
  gtk_widget_realize (domain_frame);
  iconpixmap = gdk_pixmap_create_from_xpm_d (domain_frame->window,
					     &iconmask,
					     &domain_frame->
					     style->bg[GTK_STATE_NORMAL],
					     icon_xpm);
  gdk_window_set_icon (domain_frame->window, NULL, iconpixmap, iconmask);
  gdk_window_set_icon_name (domain_frame->window, "Domain");

  gtk_object_set_data (GTK_OBJECT (domain_frame), "domain_frame",
		       domain_frame);
  gtk_container_border_width (GTK_CONTAINER (domain_frame), 1);
  gtk_signal_connect (GTK_OBJECT (domain_frame), "destroy",
		      GTK_SIGNAL_FUNC (quit_Callback), NULL);
  gtk_signal_connect (GTK_OBJECT (domain_frame), "delete_event",
		      GTK_SIGNAL_FUNC (quit_Callback), NULL);

  /* set the name if one was found in inputs or default name */
  gtk_window_set_title (GTK_WINDOW (domain_frame), "Visualisation");
  gtk_widget_set_usize (domain_frame, 400, 350);

  /*-----policy is : allow shrink,allow_grow, not auto_shrink -----------*/
  gtk_window_set_policy (GTK_WINDOW (domain_frame), TRUE, TRUE, FALSE);

  hbox2 = gtk_hbox_new (FALSE, 0);

  vbox1 = gtk_vbox_new (FALSE, 3);
  gtk_object_set_data (GTK_OBJECT (domain_frame), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox2), vbox1, FALSE, FALSE, 0);

  /*---- "Quit" button -----*/
  quit_button = gtk_button_new_from_stock (GTK_STOCK_QUIT);
  gtk_object_set_data (GTK_OBJECT (domain_frame), "quit_button", quit_button);
  gtk_signal_connect_object (GTK_OBJECT (quit_button), "clicked",
			     GTK_SIGNAL_FUNC (quit_Callback),
			     GTK_OBJECT (domain_frame));
  gtk_widget_show (quit_button);
  gtk_box_pack_start (GTK_BOX (vbox1), quit_button, FALSE, FALSE, 1);
//  gtk_widget_set_size_request (quit_button, 100, 25);
  gtk_container_border_width (GTK_CONTAINER (quit_button), 2);

  /*---- "View projection" button -----*/
  view_button = gtk_toggle_button_new_with_label ("Projection");
  gtk_object_set_data (GTK_OBJECT (domain_frame), "view_button", view_button);
//  gtk_widget_set_size_request (view_button, 100, 25);
  gtk_signal_connect_object (GTK_OBJECT (view_button), "toggled",
			     GTK_SIGNAL_FUNC (active_repere), NULL);
  gtk_widget_show (view_button);
  gtk_container_border_width (GTK_CONTAINER (view_button), 2);
  gtk_box_pack_start (GTK_BOX (vbox1), view_button, FALSE, FALSE, 1);

  /*---- "Domains" button ----*/

  properties_button = gtk_toggle_button_new_with_label ("Domains");
  gtk_object_set_data (GTK_OBJECT (domain_frame), "properties_button",
		       properties_button);
//  gtk_widget_set_size_request (properties_button, 100, 25);
  gtk_signal_connect_object (GTK_OBJECT (properties_button), "toggled",
			     GTK_SIGNAL_FUNC (active_properties), NULL);
  gtk_widget_show (properties_button);
  gtk_container_border_width (GTK_CONTAINER (properties_button), 2);
  gtk_box_pack_start (GTK_BOX (vbox1), properties_button, FALSE, FALSE, 1);

  /*---- "Context" button ----*/

  context_button = gtk_toggle_button_new_with_label ("Context");
  gtk_object_set_data (GTK_OBJECT (domain_frame), "context_button",
		       context_button);
//  gtk_widget_set_size_request (context_button, 100, 25);
  gtk_signal_connect_object (GTK_OBJECT (context_button), "toggled",
			     GTK_SIGNAL_FUNC (active_context), NULL);
  gtk_widget_show (context_button);
  gtk_container_border_width (GTK_CONTAINER (context_button), 2);
  gtk_box_pack_start (GTK_BOX (vbox1), context_button, FALSE, FALSE, 1);

  /*--- creates the drawing area where the domain is drawn  ----*/
  domain_canvas = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (domain_frame), "domain_canvas",
		       domain_canvas);
  gtk_box_pack_start (GTK_BOX (hbox2), domain_canvas, TRUE, TRUE, 0);
  gtk_widget_set_usize (domain_canvas, 200, 200);
  gtk_widget_set_events (domain_canvas, GDK_EXPOSURE_MASK |
			 GDK_BUTTON_PRESS_MASK);

  /*---- handlers of events in the drawing area ------------------*/
  gtk_signal_connect (GTK_OBJECT (domain_canvas), "expose_event",
		      GTK_SIGNAL_FUNC (domain_expose_event), NULL);
  gtk_signal_connect (GTK_OBJECT (domain_canvas), "configure_event",
		      GTK_SIGNAL_FUNC (domain_configure_event), NULL);

  /*---- handler for trying to select a point ---------------------*/
  gtk_signal_connect (GTK_OBJECT (domain_canvas), "button_press_event",
		      GTK_SIGNAL_FUNC (domain_button_press_event), NULL);


  gtk_widget_show (domain_canvas);
  gtk_container_add (GTK_CONTAINER (domain_frame), hbox2);
  gtk_widget_show (hbox2);

  return (domain_frame);
}

/************************************************************************/
/* create_rep_frame ()													*/
/************************************************************************/
GtkWidget *create_rep_frame ()
{
  GdkColor transparent;

  rep_frame = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_object_set_data (GTK_OBJECT (rep_frame), "rep_frame", rep_frame);
  gtk_window_set_title (GTK_WINDOW (rep_frame), "Projection");
  gtk_window_set_policy (GTK_WINDOW (rep_frame), TRUE, TRUE, FALSE);

  rep_canvas = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (rep_frame), "rep_canvas", rep_canvas);
  gtk_widget_show (rep_canvas);
  gtk_container_add (GTK_CONTAINER (rep_frame), rep_canvas);
  gtk_widget_set_usize (rep_canvas, 200, 180);
  gtk_widget_set_events (rep_canvas,
			 GDK_EXPOSURE_MASK |
			 GDK_BUTTON_PRESS_MASK |
			 GDK_BUTTON_RELEASE_MASK |
			 GDK_POINTER_MOTION_MASK |
			 GDK_POINTER_MOTION_HINT_MASK);

  gtk_widget_realize (GTK_WIDGET (rep_frame));
  rep_iconpixmap = gdk_pixmap_create_from_xpm (rep_frame->window,
					       &rep_iconmask,
					       &transparent,
					       "repere_icon.xpm");
  gdk_window_set_icon (rep_frame->window, NULL, rep_iconpixmap, rep_iconmask);

  /*--- when window is resized or created ---*/
  gtk_signal_connect (GTK_OBJECT (rep_canvas), "configure_event",
		      GTK_SIGNAL_FUNC (repere_configure_event), NULL);
  /*--- when window is exposed ------*/
  gtk_signal_connect (GTK_OBJECT (rep_canvas), "expose_event",
		      GTK_SIGNAL_FUNC (repere_expose_event), NULL);
  /* --- Need to know about mouse movements. --- */
  gtk_signal_connect (GTK_OBJECT (rep_canvas), "motion_notify_event",
		      GTK_SIGNAL_FUNC (repere_motion_notify_event), NULL);

  /*--- when rep_frame window is killed  ------*/
  gtk_signal_connect (GTK_OBJECT (rep_frame), "delete_event",
		      GTK_SIGNAL_FUNC (repere_exit), NULL);
  gtk_signal_connect (GTK_OBJECT (rep_frame), "destroy",
		      GTK_SIGNAL_FUNC (repere_exit), NULL);

  return (rep_frame);
}
