/* gtk_repere.c
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <polylib/polylib64.h>


#include "gtk_domain.h"
#include "gtk_repere.h"
#include "gtk_windows.h"	/*decls of  drawing areas rep_canvas,domain_canvas */
#include "gtk_ddraw.h"		/*decls of  backing pixmaps rg and dg */

extern GdkFont *font;
struct Repere repere;

/************************************************************************/
/* calc_rep_extr() :							*/
/* calcul des nouveaux extremas dans le repere 				*/
/************************************************************************/
void calc_rep_extr (void)
{
  int i;

  repere.maxx = repere.minx = 0.;
  repere.maxy = repere.miny = 0.;
  for (i = 0; i < DimNP; ++i)
    {
      if (repere.matrice[i][0] > repere.maxx)
	repere.maxx = repere.matrice[i][0];
      if (repere.matrice[i][0] < repere.minx)
	repere.minx = repere.matrice[i][0];
      if (repere.matrice[i][1] > repere.maxy)
	repere.maxy = repere.matrice[i][1];
      if (repere.matrice[i][1] < repere.miny)
	repere.miny = repere.matrice[i][1];
    }
}

/************************************************************************/
/* active_repere()                                                      */
/* Active/inactive la fentre du repre                                 */
/************************************************************************/
void active_repere (GtkWidget * widget, gpointer data)
{
  if (1)
    {
      if (!GTK_WIDGET_VISIBLE (GTK_WIDGET (rep_frame)))
	gtk_widget_show (GTK_WIDGET (rep_frame));
      else
	gtk_widget_hide (GTK_WIDGET (rep_frame));
    }
}

/************************************************************************/
/* repere_redraw()                                                      */
/* procedure appelee lorsque le repere doit etre redessine              */
/************************************************************************/
void repere_redraw (GdkDrawable * pixmap)
{

  GdkRectangle update_rect;

  int x0, y0, x, y;
  int i, r1, r2;

  char axis[2];

	/*--- clear domain window ----*/
  gdk_draw_rectangle (pixmap, whitePen, TRUE, 0, 0,
		      rep_canvas->allocation.width,
		      rep_canvas->allocation.height);

  /*la taille de la fenetre doit correspondre a la taille du
     dessin du polydre */

  repere.width = (int) (rep_canvas->allocation.width) - 2 * BORD;
  repere.height = (int) (rep_canvas->allocation.height) - 2 * BORD;

  if (repere.maxx == repere.minx)
    {
      repere.maxx += 1;
      repere.minx -= 1;
    }
  if (repere.maxy == repere.miny)
    {
      repere.maxy += 1;
      repere.miny -= 1;
    }

  r1 = repere.width * DHEIGHT;
  r2 = repere.height * DWIDTH;

  if (r2 <= 0. || r1 <= 0.)
    return;

  x0 =
    BORD - (float) (repere.minx / (repere.maxx - repere.minx) * repere.width);
  y0 =
    repere.height + BORD +
    (float) (repere.miny / (repere.maxy - repere.miny) * repere.height);

  for (i = 0; i < DimNP; ++i)
    {

      x =
	BORD +
	(float) ((repere.matrice[i][0] - repere.minx) /
		 (repere.maxx - repere.minx) * (repere.width));
      y =
	repere.height + BORD -
	(float) ((repere.matrice[i][1] - repere.miny) /
		 (repere.maxy - repere.miny) * (repere.height));
      gdk_draw_line (pixmap, rgGC, x0, y0, x, y);
      x = x + 3;
      y = y - 3;

      sprintf (axis, "%c", (char) 'i' + i);
      gdk_draw_string (pixmap, font, rgGC, x + 4, y, axis);
    }
  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = rep_canvas->allocation.width;
  update_rect.height = rep_canvas->allocation.height;
	/*--- leads to a call to a expose_event on rep_canvas ---*/
  gtk_widget_draw (rep_canvas, &update_rect);

}

/************************************************************************/
/* rep_std()                                                            */
/************************************************************************/
void rep_std ()
{
  rep_init ();
  repere_redraw (rg);
  domain_redraw (dg, NULL);
}

/************************************************************************/
/* rep_init()								*/
/************************************************************************/
void rep_init ()
{
  int i;
  /* maximum MAXDIM assignations here ! */
  repere.matrice[0][0] = 1.;
  repere.matrice[0][1] = 0.;
  repere.matrice[1][0] = 0.;
  repere.matrice[1][1] = 1.;
  repere.matrice[2][0] = 2.6;
  repere.matrice[2][1] = 2.6;
  repere.matrice[3][0] = -4.;
  repere.matrice[3][1] = 4.;
  for (i = 4; i < MAXDIM; ++i)
    {
      repere.matrice[i][0] = 2.;
      repere.matrice[i][1] = i - 3;
    }
  calc_rep_extr ();
}
