/* domains.h
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
 
          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/

#ifndef DOMAINS_H_
#define DOMAINS_H_


#include <polylib/polylib64.h>

#include "visutypes.h"

extern Matrix *Scanning_Matrix (Polyhedron * P, Matrix * order, int ws);
extern int FORALL_P_do (Polyhedron * P, Value * pt, int (*f) (Value *));

extern int DansPolyedre (Polyhedron * P, Value * pt);
extern gboolean DansDomaine (Polyhedron * P, Value * pt);
extern int nb_pts_poly (Polyhedron *);

extern char *writeDomain (Polyhedron *);

extern void clear_A_domains (void);
extern void compute_A_domains (void);
extern void union_intpoints_domains (void);

extern void Affich_P_domains (Domain * domain, gint row);
extern void Affich_NOT_P_domains (Domain * domain, gint row);

#endif
