
//
// Les listes ( la OCAML)
//

#include "list.h"

void freelist(list l)
{
    if(l!= NULL) 
    {
        freelist(l->tail);
        free(l);
	l = NULL;
    }
}

list nil()
{
    return NULL;
}

list cons(T v, list l)
{
    element *tmp = malloc(sizeof(element));
    tmp->head = v;
    tmp->tail = l;
    return tmp;
}

void map(void (*f)(T v), list l)
{
    element *tmp = l;
    while(tmp != NULL)
    {
	f(tmp->head);
	tmp = tmp->tail;
    }
}

list concat(list l1, list l2)
//  Attention ! Cette fonction se comporte comme
//  si on avait fait freelist(l1) et freelist(l2)
{
    if(l1 == NULL) 
    { 
        return l2;
    }
    else
    {
	element *tmp = cons(l1->head, concat(l1->tail, l2));
        free(l1);
	return tmp;
    }
}

