#include "look.h"
#include "lwm.h"
#include "client.h"
#include "resource.h"

// init the pixmaps used for shapes
extern void init_pixmaps(Client* c)
{
#ifdef LOOK_R51
	int i,j;
	static char gray_bits[round_tab_xsize*50]; // XXX redimensionner correctement a
	static char ul_corner[2*lt_height]={
				0,240,
				0,252,
				0,254,
				0,255,
				0,255,
				0,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				128,255,
				0,255,
				0,255,
				0,254,
				0,252,
				0,252-4-8,
				0,252-4-8-16-32,
				
				  
	};
	static char dl_corner[4]={14,14,12,0};
	static char dr_corner[4]={7,7,3,0};
	static char ur_corner[4]={0,3,7,7};

	for(j=0;j<titleHeight()*2/3;j++)
		for(i=0;i<round_tab_xsize;i++)
		{
			gray_bits[i/8+j*round_tab_xsize/8]|=(2*i*i+3*(j-titleHeight()*2/3)*(j-titleHeight()*2/3)<400)<<(i%8);
		}
	c->p = XCreatePixmapFromBitmapData(dpy, c->parent,gray_bits,round_tab_xsize ,titleHeight()*2/3,c->screen->black,c->screen->white,1);
	c->dr = XCreatePixmapFromBitmapData(dpy, c->parent,dr_corner,4 ,4,c->screen->black,c->screen->white,1);
	c->dl = XCreatePixmapFromBitmapData(dpy, c->parent,dl_corner,4 ,4,c->screen->black,c->screen->white,1);
	c->ul = XCreatePixmapFromBitmapData(dpy, c->parent,ul_corner,lt_width ,lt_height,c->screen->black,c->screen->white,1);
	c->ur = XCreatePixmapFromBitmapData(dpy, c->parent,ur_corner,4 ,4,c->screen->black,c->screen->white,1);
#endif
}
	
// shape_mode can have the following values :
// ShapeSubtract/CREATE_SHAPE to create the window cuts that give it its shape
// ShapeUnion/DESTROY_SHAPE to destroy the cuts
// recycle is true if we recycle the whole window shape
/*ARGSUSED*/
extern void 
setShape(Client *c,int shape_mode,char recycle) {
	int n;
	int order;
	XRectangle* rect;
	XRectangle new_rect[2];
	
	if (shape_mode==DESTROY_SHAPE)
		return;
	
	if (shape) {
		if (shape_mode!=DESTROY_SHAPE)
		{
			XShapeSelectInput(dpy, c->window, ShapeNotifyMask);
			rect = XShapeGetRectangles(dpy, c->window, ShapeBounding,
				&n, &order);
			
			// FIXME case of a shaped window
/*			if (n > 1)
			{	
				XShapeCombineShape(dpy, c->parent, ShapeBounding,
					border - 1, border - 1, c->window,
					ShapeBounding, ShapeSet);
			}*/
	
			new_rect[0].x=rect->x;
			new_rect[0].y=rect->y+titleHeight();
			new_rect[0].width=rect->width+2*border+2*lt_width;
			new_rect[0].height=rect->height+2*border/*+titleHeight()*/;
				
			XFree(rect);
			
			// create the yellow tab
			new_rect[1].x=c->tab_xpos;
			new_rect[1].y=0;
			new_rect[1].width=c->tab_width+round_tab_xsize;
			new_rect[1].height=titleHeight();
			
			// recreate the window
			XShapeCombineRectangles(dpy, c->parent, ShapeBounding,-lt_width,0, new_rect,2, ShapeSet,Unsorted);
		
		}
	
#ifdef LOOK_R51
		// the down right corner
		XShapeCombineMask(dpy, c->parent, ShapeBounding,c->size.width-DEFAULT_BORDER+lt_width ,c->size.height+titleHeight()-DEFAULT_BORDER, c->dr, shape_mode);
		
		// the down left corner
		XShapeCombineMask(dpy, c->parent, ShapeBounding,lt_width ,c->size.height-DEFAULT_BORDER+titleHeight(), c->dl, shape_mode);
		
		// the up right corner, this doesn't exist if the width is too low
		if (c->size.width-DEFAULT_BORDER>c->tab_width+round_tab_xsize)
		{
			XShapeCombineMask(dpy, c->parent, ShapeBounding,c->size.width-DEFAULT_BORDER+lt_width ,titleHeight()*2/3, c->ur, shape_mode);
		}
		
		// the up up right corner, always exists but not always visible
		XShapeCombineMask(dpy, c->parent, ShapeBounding,c->size.width-DEFAULT_BORDER+lt_width ,0, c->ur, shape_mode);
#endif

	}
}


/*ARGSUSED*/
extern int
shapeEvent(XEvent *ev) {
	if (shape && ev->type == shape_event) {
		Client *c;
		XShapeEvent *e = (XShapeEvent *)ev;

		c = Client_Get(e->window);
		if (c != 0)
			setShape(c,CREATE_SHAPE,false);
		return 1;
	}
	return 0;
}

/*ARGSUSED*/
extern int
isShaped(Window w) {
	int	n;
	int	order;
	XRectangle	*rect;

	rect = XShapeGetRectangles(dpy, w, ShapeBounding, &n, &order);
	XFree(rect);

	return (n > 1);
}

extern int
serverSupportsShapes(void) {
	int shape_error;
	return XShapeQueryExtension(dpy, &shape_event, &shape_error);
}
