#ifndef __look_h_
#define __look_h_

/* --- Administrator-configurable defaults. --- */

// define to use freetype aa fonts
#define USE_FT_FONTS
//#undef USE_FT_FONTS

// define if you want a BeOS ~R5.1 look
// else you get a classic BeOS R5 look
#define LOOK_R51
#undef LOOK_R51

/*
 *
 *                 tab_width 
 *                <---------->
 *               
 *              <->lt_width   <->round_tab_xsize
 *               ______________
 *            ^ /              \___________
 *  lt_height | |   bounding region        \
 *            | \     __________________   |
 *            v  \   |                  |  |
 *                |  | clip region      |  |
 *                |  |                  |  |
 *                |  |                  |  |
 *                |  |                  |  |
 *                |  |                  |  |
 *                |  |__________________|  |
 *                \________________________/
 *
 *
 */


// fonts
#define DEFAULT_TITLE_FONT "-*-lucida-bold-r-normal-sans-14-*-*-*-p-*-iso8859-1"
#define DEFAULT_POPUP_FONT "-*-lucida-medium-r-normal-sans-12-*-*-*-p-*-iso8859-1"
#define DEFAULT_FT_TITLE_FONT "arial.ttf"
//#define DEFAULT_FT_TITLE_FONT "Swiss721_Bold.ttf"

#define DEFAULT_TERMINAL "rxvt"

// the border size
#define DEFAULT_BORDER 4

// /!\ multiple of 8 required for lt_width !

#ifdef LOOK_R51
// dano look
#define lt_width 16
#define round_tab_xsize 16
#else
// classic Be look
#define lt_width 0
#define round_tab_xsize 20
#endif

// the minimum tab width
#define min_tab 30

#define lt_height 40


#endif

