#include "font.h"
#include "color.h"
#include "error.h"


FT_Face face;

void ft_font_init()
{
#ifdef USE_FT_FONTS
       FT_Library library;
       if (FT_Init_FreeType(&library))
       {
       	panic("can't init freetype\n");
       }

       if (FT_New_Face( library,DEFAULT_FT_TITLE_FONT,0,&face ))
       {
       	panic("can't init freetype font\n");
       }
       FT_Set_Char_Size(face,0,4*64,300,300);
       

#endif
}

void FTDrawString(Display* dpy,Drawable d,GC gc,int xpos,int ypos,char* text,int num_chars,int active)
{
#ifdef USE_FT_FONTS
       FT_GlyphSlot  slot = face->glyph;  // a small shortcut
       int           pen_x, pen_y, n,i,j,error;

       pen_x = xpos;
       pen_y = ypos;
       
       for ( n = 0; n < num_chars; n++ )
       {
         error=FT_Load_Char(face,text[n],FT_LOAD_RENDER);
         if (error) continue;  // ignore errors
         
         // now, draw to our target surface
	
	 for(i=0;i<slot->bitmap.rows;i++)
		for(j=0;j<slot->bitmap.width;j++)
		{
		unsigned char intensity=slot->bitmap.buffer[i*(slot->bitmap.width)+j];
		XSetForeground(	dpy,gc,active?x_title_font_fg_colors[intensity]:x_title_font_bg_colors[intensity]);
		
		XDrawPoint(dpy,d,gc,pen_x+slot->bitmap_left+j,pen_y-slot->bitmap_top+i);
		}
                         
         // increment pen position 
         pen_x += slot->advance.x >> 6;
       }
#endif
}


