#include "look.h"
#include "shape.h"
#include "manage.h"
#include "resource.h"
#include "mouse.h"
#include "lwm.h"

/*
 *    Dispatcher for main event loop.
 */
typedef struct Disp Disp;
struct Disp {
	int	type;
	void	(*handler)(XEvent *);
};

static void expose(XEvent *);
static void buttonpress(XEvent *);
static void buttonrelease(XEvent *);
static void maprequest(XEvent *);
static void configurereq(XEvent *);
static void unmap(XEvent *);
static void destroy(XEvent *);
static void clientmessage(XEvent *);
static void colormap(XEvent *);
static void property(XEvent *);
static void reparent(XEvent *);
static void enter(XEvent *);
static void motionnotify(XEvent *);
static void keypress(XEvent *);

void reshaping_motionnotify(XEvent *);

static Disp disps[] =
{
	{Expose, expose},
	{MotionNotify, motionnotify},
	{KeyPress, keypress},
	{ButtonPress, buttonpress},
	{ButtonRelease, buttonrelease},
	{MapRequest, maprequest},
	{ConfigureRequest, configurereq},
	{UnmapNotify, unmap},
	{DestroyNotify, destroy},
	{ClientMessage, clientmessage},
	{ColormapNotify, colormap},
	{PropertyNotify, property},
	{ReparentNotify, reparent},
	{EnterNotify, enter},
	{CirculateRequest, 0},
	{ConfigureNotify, 0},
	{CreateNotify, 0},
	{GravityNotify, 0},
	{MapNotify, 0},
	{MappingNotify, 0},
	{SelectionClear, 0},
	{SelectionNotify, 0},
	{SelectionRequest, 0},
	{NoExpose, 0},
};

extern void
dispatch(XEvent * ev) {
	Disp * p;

	for (p = disps; p < disps + sizeof(disps)/sizeof(disps[0]); p++) {
		if (p->type == ev->type) {
			if (p->handler != 0)
				p->handler(ev);
			return;
		}
	}

	if (!shapeEvent(ev))
		fprintf(stderr, "%s: unknown event %d\n", argv0, ev->type);
}

static void
expose(XEvent * ev) {
	Client * c;
	Window w;	/* Window the expose event is for. */

	/* Only handle the last in a group of Expose events. */
	if (ev->xexpose.count != 0) return;

	w = ev->xexpose.window;

	/*
	* We don't draw on the root window so that people can have
	* their favourite Spice Girls backdrop...
	*/
	if (getScreenFromRoot(w) != 0)
		return;

	/* Decide what needs redrawing: window frame or menu? */
	if (current_screen && w == current_screen->popup) {
		if (mode == wm_menu_up)
			menu_expose();
		else if (mode == wm_reshaping && current != 0)
		{
			// we are reshaping so expose means we must resize the window too
			// XXX do this only if there has been enough time since last refresh
			XMoveResizeWindow(dpy, current->window,
				border+lt_width, border + titleHeight(),
				current->size.width - 2 * border,
				current->size.height - 2 * border);
			setShape(current,CREATE_SHAPE,false);
			Client_DrawBorder(current, true);
	
			size_expose();
		}
	} else {
		c = Client_Get(w);
		if (c != 0) {
			Client_DrawBorder(c, c == current);
		}
	}
}

static void
keypress(XEvent *ev) {
printf("test\n");
}

static void
buttonpress(XEvent *ev) {
	Client *c;
	XButtonEvent *e = &ev->xbutton;
	int quarter;
	
	/* If we're getting it already, we're not in the market for more. */
	if (mode != wm_idle) return;

	
	c = Client_Get(e->window);
	if (c && (e->window == c->parent)) {
		/* Click went to our frame around a client. */

		/* The close ``box''. */
		quarter = (border + titleHeight()) / 4;
		if (e->x > (quarter + 2) && e->x < (3 + 3*quarter) && e->y > quarter && e->y <= 3*quarter) {
			Client_Close_Pend(c);
			return;
		}

		/* Somewhere in the rest of the frame. */
		if (e->button == HIDE_BUTTON) {
			if (e->state & ShiftMask) {
				Client_Back(c);
			} else {
				hide(c);
			}
			return;
		}
		if (e->button == MOVE_BUTTON) {
			Client_Move(c);
			return;
		}		
		if (e->button == RESHAPE_BUTTON) {
			XSetWindowAttributes attr;
			
			XMapRaised(dpy, c->parent);
			
			// use save_under during reshape/move
			attr.save_under=True;
			XChangeWindowAttributes(dpy, c->window, CWSaveUnder, &attr);
			XChangeWindowAttributes(dpy, c->parent, CWSaveUnder, &attr);
	

			/* Lasciate ogni speranza voi ch'entrate...  */

			// XXX FIXME not checking the good places
			if (e->x <= border && e->y <= border) {
				Client_ReshapeEdge(c, ETopLeft);
			} else if (e->x >= (c->size.width - border) && e->y <= border) {
				Client_ReshapeEdge(c, ETopRight);
			} else if (e->x >= (c->size.width - border) && e->y >= (c->size.height + titleHeight() - border)) {
				Client_ReshapeEdge(c, EBottomRight);
			} else if (e->x <= border && e->y >= (c->size.height + titleHeight() - border)) {
				Client_ReshapeEdge(c, EBottomLeft);
			} else if (e->x > border && e->x < (c->size.width - border) && e->y < border) {
				Client_ReshapeEdge(c, ETop);
			} else if (e->x > border && e->x < (c->size.width - border) && e->y >= border && e->y < (titleHeight() + border)) {
				Client_Move(c);
			} else if (e->x > (c->size.width - border) && e->y > border && e->y < (c->size.height + titleHeight() - border)) {
				Client_ReshapeEdge(c, ERight);
			} else if (e->x > border && e->x < (c->size.width - border) && e->y > (c->size.height - border)) {
				Client_ReshapeEdge(c, EBottom);
			} else if (e->x < border && e->y > border && e->y < (c->size.height + titleHeight() - border)) {
				Client_ReshapeEdge(c, ELeft);
			}
			return;
		}
		return;
	}

	/* Deal with root window button presses. */
	if (e->window == e->root) {
		if (e->button == Button3) {
			cmapfocus(0);
			menuhit(e);
		} else {
			shell(getScreenFromRoot(e->root), e->button, e->x, e->y);
		}
	}
}

static void
buttonrelease(XEvent *ev) {
        int quarter;
	XButtonEvent *e = &ev->xbutton;
	Client * c;
	
        c = Client_Get(e->window);
        
        if (mode == wm_menu_up)
		menu_buttonrelease(ev);
	else if (mode == wm_reshaping)
	{	
		XSetWindowAttributes attr;
		// remove save_under after reshape/move
		attr.save_under=False;
		XChangeWindowAttributes(dpy, c->window, CWSaveUnder, &attr);
		XChangeWindowAttributes(dpy, c->parent, CWSaveUnder, &attr);
//		printf("end\n");

		XUnmapWindow(dpy, current_screen->popup);
	}
        else if ((e->window == c->parent) && c->close_pending) {
		/* The ``box''. */
		quarter = (border + titleHeight()) / 4;
		if (e->x > (quarter + 2) && e->x < (3 + 3*quarter) && e->y > quarter && e->y <= 3*quarter) {
			Client_Close(c);
		}
        }
		
	mode = wm_idle;
}

static void
maprequest(XEvent *ev) {
	Client * c;
	XMapRequestEvent * e = &ev->xmaprequest;
	
	c = Client_Get(e->window);
	
	if (c == 0 || c->window != e->window) {
		int screen;
		for (screen = 0; screen < screen_count; screen++)
			scanWindowTree(screen);
		c = Client_Get(e->window);
		if (c == 0 || c->window != e->window) {
			fprintf(stderr, "MapRequest for non-existent window!\n");
			return;
		}
	}
	
	unhidec(c, 1);
	
	switch (c->state) {
	case WithdrawnState:
		if (getScreenFromRoot(c->parent) != 0) {
			manage(c, 0);
			break;
		}
		XReparentWindow(dpy, c->window, c->parent, border+lt_width,
			border + titleHeight());
		XAddToSaveSet(dpy, c->window);
		/*FALLTHROUGH*/
	case NormalState:
		XMapRaised(dpy, c->parent);
		XMapWindow(dpy, c->window);
		Client_SetState(c, NormalState);
		break;
	}
}

static void
unmap(XEvent *ev) {
	Client *c;
	XUnmapEvent *e = &ev->xunmap;

	c = Client_Get(e->window);
	if (c == 0) return;

	/*
	 * In the description of the ReparentWindow request we read: "If the window
	 * is mapped, an UnmapWindow request is performed automatically first". This
	 * might seem stupid, but it's the way it is. While a reparenting is pending
	 * we ignore UnmapWindow requests.
	 */
	if (c->internal_state == IPendingReparenting) {
		c->internal_state = INormal;
		return;
	}

	/* "This time it's the real thing." */

	if (c->state == IconicState) {
		/*
		 * Is this a hidden window disappearing? If not, then we
		 * aren't interested because it's an unmap request caused
		 * by our hiding a window.
		 */
		if (e->send_event)
			unhidec(c, 0); /* It's a hidden window disappearing. */
	} else {
		/* This is a plain unmap, so withdraw the window. */
		withdraw(c);
	}

	c->internal_state = INormal;
}

static void
configurereq(XEvent *ev) {
	XWindowChanges wc;
	Client *c;
	XConfigureRequestEvent *e = &ev->xconfigurerequest;
	
	c = Client_Get(e->window);
	if (c && c->window == e->window) {
		/*
		* ICCCM section 4.1.5 says that the x and y coordinates here
		* will have been "adjusted for the border width".
		* NOTE: this may not be the only place to bear this in mind.
		*/
		if (e->value_mask & CWBorderWidth) {
			e->x -= e->border_width;
			e->y -= e->border_width;
		} else {
			/*
			* The ICCCM also says that clients should always set the
			* border width in a configure request. As usual, many don't.
			*/
			e->x--;
			e->y--;
		}

		if (e->value_mask & CWX)
			c->size.x = e->x;
		if (e->value_mask & CWY)
			c->size.y = e->y;
		if (e->value_mask & CWWidth)
			c->size.width = e->width + 2 * border;
		if (e->value_mask & CWHeight)
			c->size.height = e->height + 2 * border;
		if (e->value_mask & CWBorderWidth)
			c->border = e->border_width;

		if (getScreenFromRoot(c->parent) == 0) {
			wc.x = c->size.x-lt_width;
			wc.y = c->size.y - titleHeight();
			wc.width = c->size.width+lt_width;
			wc.height = c->size.height + titleHeight();
			wc.border_width = 1;
			wc.sibling = e->above;
			wc.stack_mode = e->detail;
			
			XConfigureWindow(dpy, e->parent, e->value_mask, &wc);
			sendConfigureNotify(c);
		}
	}
	if (c && (c->internal_state == INormal)) {
		wc.x = border;
		wc.y = border;
	} else {
		wc.x = e->x;
		wc.y = e->y;
	}

	wc.width = e->width;
	wc.height = e->height;
	wc.border_width = 0;
	wc.sibling = e->above;
	wc.stack_mode = e->detail;
	e->value_mask |= CWBorderWidth;
	
	XConfigureWindow(dpy, e->window, e->value_mask, &wc);
	
	if (c) {
		XMoveResizeWindow(dpy, c->parent,
			c->size.x-lt_width, c->size.y - titleHeight(),
			c->size.width+lt_width, c->size.height + titleHeight());
		XMoveWindow(dpy, c->window, border+lt_width, border + titleHeight());
	}
}

static void
destroy(XEvent *ev) {
	Client * c;
	Window w = ev->xdestroywindow.window;

	c = Client_Get(w);
	if (c == 0)
		return;

	Client_Remove(c);
}

static void
clientmessage(XEvent *ev) {
	Client * c;
	XClientMessageEvent * e = &ev->xclient;

	if (e->message_type == wm_change_state) {
		c = Client_Get(e->window);
		if (c == 0) return;
		if (e->format == 32 && e->data.l[0] == IconicState && normal(c))
			hide(c);
		return;
	}
}

static void
colormap(XEvent *ev) {
	Client * c;
	XColormapEvent * e = &ev->xcolormap;
	
	if (e->new) {
		c = Client_Get(e->window);
		if (c) {
			c->cmap = e->colormap;
			if (c == current)
				cmapfocus(c);
		} else {
			Client_ColourMap(ev);
		}
	}
}

static void
property(XEvent * ev) {
	Client * c;
	XPropertyEvent * e = &ev->xproperty;
	
	c = Client_Get(e->window);
	if (c == 0)
		return;
	
	if (e->atom == _mozilla_url || e->atom == XA_WM_NAME) {
		setShape(c,DESTROY_SHAPE,true);
		getWindowName(c);
		setShape(c,CREATE_SHAPE,true);
		setactive(c, c == current, 0L);
	} else if (e->atom == XA_WM_TRANSIENT_FOR) {
		getTransientFor(c);
	} else if (e->atom == XA_WM_NORMAL_HINTS) {
		getNormalHints(c);
	} else if (e->atom == wm_colormaps) {
		getColourmaps(c);
		if (c == current)
			cmapfocus(c);
	}
}

static void
reparent(XEvent *ev) {
	Client * c;
	XReparentEvent * e = &ev->xreparent;
	
	if (getScreenFromRoot(e->event) == 0 || e->override_redirect || getScreenFromRoot(e->parent) != 0)
		return;
	
	c = Client_Get(e->window);
	if (c != 0 && (getScreenFromRoot(c->parent) != 0 || withdrawn(c)))
		Client_Remove(c);
}

static void
enter(XEvent *ev) {
	Client *c;

	c = Client_Get(ev->xcrossing.window);
	if (c == 0)
		return;

	if (c != current && !c->hidden) {
		/* Take focus away from current holder. */
		if (current) {
                        current->close_pending = False;
			setactive(current, 0, 0L);
                }

		/* Give focus to new holder. */
		current = c;
		setactive(current, 1, ev->xcrossing.time);
	}
}

static void
motionnotify(XEvent *ev) {
	if (mode == wm_reshaping)
		reshaping_motionnotify(ev);
	else if (mode == wm_menu_up)
		menu_motionnotify(ev);
}

/*ARGSUSED*/
void
reshaping_motionnotify(XEvent* ev) {
	int	nx;	/* New x. */
	int	ny;	/* New y. */
	int	ox;	/* Original x. */
	int	oy;	/* Original y. */
	int	ndx;	/* New width. */
	int	ndy;	/* New height. */
	int	odx;	/* Original width. */
	int	ody;	/* Original height. */
	int	pointer_x;
	int	pointer_y;

	if (mode != wm_reshaping) return;

	getMousePosition(&pointer_x, &pointer_y);

	if (interacting_edge != ENone) {
		// window will be resized
		nx = ox = current->size.x;
		ny = oy = current->size.y;
		ndx = odx = current->size.width;
		ndy = ody = current->size.height;
		
		Client_SizeFeedback();
		
		/* Vertical. */
		switch (interacting_edge) {
		case ETop:
		case ETopLeft:
		case ETopRight:
			ndy += (current->size.y - pointer_y);
			ny = pointer_y;
			break;
		case EBottom:
		case EBottomLeft:
		case EBottomRight:
			ndy = pointer_y - current->size.y;
			break;
		default:	break;
		}

		/* Horizontal. */
		switch (interacting_edge) {
		case ERight:
		case ETopRight:
		case EBottomRight:
			ndx = pointer_x - current->size.x;
			break;
		case ELeft:
		case ETopLeft:
		case EBottomLeft:
			ndx += (current->size.x - pointer_x);
			nx = pointer_x;
			break;
		default: break;
		}

		// set the shappe according to new size
		Client_MakeSane(current, interacting_edge, &nx, &ny, &ndx, &ndy);
		
		XMoveResizeWindow(dpy, current->parent,
			current->size.x-lt_width, current->size.y - titleHeight(),
			current->size.width+lt_width, current->size.height + titleHeight());
		
		if (current->size.width == odx && current->size.height == ody) 
		{
			if (current->size.x != ox || current->size.y != oy)
				sendConfigureNotify(current);
		} else
		{	
			// move/place the window
/*			XMoveResizeWindow(dpy, current->window,
				border+lt_width, border + titleHeight(),
				current->size.width - 2 * border,
				current->size.height - 2 * border);*/
			setShape(current,CREATE_SHAPE,false);
			Client_DrawBorder(current, true);
			
		}

	} else {
		nx = pointer_x + start_x;
		ny = pointer_y + start_y;

		Client_MakeSane(current, interacting_edge, &nx, &ny, 0, 0);
		XMoveWindow(dpy, current->parent,
			current->size.x-lt_width, current->size.y - titleHeight());
		sendConfigureNotify(current);
	}
}
